/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/

var STBPluginTweetThis = Object.create(STBModule.prototype);

STBPluginTweetThis.name = "PluginTweetThis";

STBPluginTweetThis.initPlugin = function() {
	var elements = $(".tweet-this:not(.__done)");

	if (elements.length) {
		elements.click(function(e) {
			e.preventDefault();

			var 
				text	= $(this).find(".tweet-this-content").text(),
				url		= "https://twitter.com/intent/tweet?text=" + escape(text) + "&url=" + escape(window.location.href),
				menu	= "width=566,height=592,location=yes,directories=no,channelmode=no,menubar=no,resizable=no,scrollbars=no,status=no,toolbar=no";


			window.open(
				url , 
				"tweetwindow",
				menu
			);

			$(this).addClass("__done");
		})
	}
}

STBPluginTweetThis.runOnReady = function() {
	STBPluginTweetThis.initPlugin();
};

STBPluginTweetThis.runOnContentUpdate = function() {
	STBPluginTweetThis.initPlugin();
};

site.registerModule(STBPluginTweetThis);